REM  *****  BASIC  *****
'By KreaAktiv.ch 2009
'Daten von: http://grandzebu.net
'Dieses Script untersteht der GNU-Lizenz. (General Public License)
'Dieses Script darf von jedermann kostenlos benutzt und geändert werden,
'solange der Copyright-Verweis und die restlichen Kommentare erhalten bleiben.
'Mit dem Einsatz dieses Skripts akzeptieren Sie, dass KreAktiv von jeglicher
'Haftung und Gewährleistung hinsichtlich des Einsatzes befreit ist.
'Der Verkauf dieses Skripts, auch in modifizierter Form, ist ohne
'vorherige Absprache ausdrücklich untersagt.
'In jeden Fall muss der Copyright-Verweis und die restlichen Kommentare
'erhalten bleiben.
'*********************************************************************
'* Functionen fuer Barcode EAN13
'* Benoetigt den Zeichensatz ean13.ttf (Code EAN13)
'*********************************************************************

Public Function EAN13(chaine As String) As String
'*********************************************************************
  'Cette fonction est régie par la Licence Générale Publique Amoindrie GNU (GNU LGPL)
  'V 1.2.1rh
  'Paramètres : une chaine de 12 chiffres
  'Retour : * une chaine qui, affichée avec la police EAN13.TTF, donne le code barre
  
  'START Deklarationen
  Dim i As Integer
  Dim checksum As Integer
  Dim first As Integer
  Dim CodeBarre As String
  Dim table As Boolean
  'ENE Deklarationen
  
  EAN13 = ""
  'Vérifier qu'il y a 12 caractères
  If len(chaine) <> 12 Then
    If len(chaine) = 13 Then
      chaine = Left$(chaine, 12)
    Else
      chaine = Right$("000000000000" & chaine, 12)
    End If
  End If
  'Et que ce sont bien des chiffres
  For i = 1 To 12
    If Asc(Mid$(chaine, i, 1)) < 48 Or Asc(Mid$(chaine, i, 1)) > 57 Then
      i = 0
      Exit For
    End If
  Next
  If i = 13 Then
    'Calcul de la clé de contrôle
    For i = 12 To 1 Step -2
      checksum = checksum + Val(Mid$(chaine, i, 1))
    Next
    checksum = checksum * 3
    For i = 11 To 1 Step -2
      checksum = checksum + Val(Mid$(chaine, i, 1))
    Next
    chaine = chaine & (10 - checksum Mod 10) Mod 10
    'Le premier chiffre est pris tel quel, le deuxième vient de la table A
    CodeBarre = Left$(chaine, 1) & Chr$(65 + Val(Mid$(chaine, 2, 1)))
    first = Val(Left$(chaine, 1))
    For i = 3 To 7
      table = False
       Select Case i
       Case 3
         Select Case first
         Case 0 To 3
           table = True
         End Select
       Case 4
         Select Case first
         Case 0, 4, 7, 8
           table = True
         End Select
       Case 5
         Select Case first
         Case 0, 1, 4, 5, 9
           table = True
         End Select
       Case 6
         Select Case first
         Case 0, 2, 5, 6, 7
           table = True
         End Select
       Case 7
         Select Case first
         Case 0, 3, 6, 8, 9
           table = True
         End Select
       End Select
     If table Then
       CodeBarre = CodeBarre & Chr$(65 + Val(Mid$(chaine, i, 1)))
     Else
       CodeBarre = CodeBarre & Chr$(75 + Val(Mid$(chaine, i, 1)))
     End If
   Next
    CodeBarre = CodeBarre & "*"   'Ajout séparateur central
    For i = 8 To 13
      CodeBarre = CodeBarre & Chr$(97 + Val(Mid$(chaine, i, 1)))
    Next
    CodeBarre = CodeBarre & "+"   'Ajout de la marque de fin 
    EAN13 = CodeBarre
  Else
    EAN13 = 	"Der Code enthaelt falsche Zeichen"
  End If
End Function